import tkinter as tk

def create_window(title, size='1000x500'):

    root = tk.Tk()
    root.title(title)
    root.geometry(size)

    return root


def create_frames(container):

    left_frame = tk.Frame(container)
    left_frame.pack(side=tk.LEFT, padx=50)
    
    right_frame = tk.Frame(container)
    right_frame.pack(side=tk.RIGHT, padx=50)
 
    control_box = tk.Frame(left_frame)
    control_box.pack(side=tk.TOP, pady=10)

    return control_box, right_frame


def digitizing_control(container):

    lbl_1 = tk.Label(container,
                     text='Digitizing Parameters')
    lbl_1.pack()

    frame = tk.Frame(container, bg='blue', bd=2)
    frame.pack()

    lbl_2 = tk.Label(frame, text='Number of Points')
    lbl_2.pack(fill=tk.X)

    var_num = tk.StringVar()
    ent_1 = tk.Entry(frame, textvariable=var_num,
                     justify=tk.CENTER)
    ent_1.pack(fill=tk.X)

    lbl_3 = tk.Label(frame, text='Sampling Frequency (Hz)')
    lbl_3.pack(fill=tk.X)

    var_samp_freq = tk.StringVar()
    ent_2 = tk.Entry(frame, textvariable=var_samp_freq,
                      justify=tk.CENTER)
    ent_2.pack(fill=tk.X)

    return var_num, var_samp_freq


def waveform_control(container):

    lbl_1 = tk.Label(container, text='Waveform Parameters')
    lbl_1.pack()

    frame = tk.Frame(container, bg='blue', bd=2)
    frame.pack()

    lbl_2 = tk.Label(frame, text='Amplitude')
    lbl_2.pack(fill=tk.X)

    var_a = tk.StringVar()
    ent_1 = tk.Entry(frame, textvariable=var_a,
                     justify=tk.CENTER)
    ent_1.pack(fill=tk.X)

    lbl_3 = tk.Label(frame, text='Frequency (Hz)')
    lbl_3.pack(fill=tk.X)

    var_f = tk.StringVar()
    ent_2 = tk.Entry(frame, textvariable=var_f,
                     justify=tk.CENTER)
    ent_2.pack(fill=tk.X)

    lbl_4 = tk.Label(frame, text='Shape')
    lbl_4.pack(fill=tk.X)

    var_shape = tk.StringVar()
    options = ['Sine', 'Cosine', 'DC Level', 'Square', 
               'Sawtooth', 'Triangle', 'User-Defined']
    opm = tk.OptionMenu(frame, var_shape, *options)
    opm.pack(fill=tk.X)

    return var_a, var_f, var_shape


def action_button(container, label, action):
    
    frame = tk.Frame(container)
    frame.pack(pady=8)
    
    btn = tk.Button(frame, text=label, command=action)
    btn.pack()

    return btn


def get_dig_entries(var_num, var_samp_freq):

    num = int(var_num.get())
    samp_freq = float(var_samp_freq.get())

    return num,samp_freq


def get_wav_entries(var_a, var_f, var_shape):

    shape = var_shape.get()
    if shape == 'User-Defined':
        a = 0
        f = 0
    elif shape == 'DC Level':
        a = float(var_a.get())
        f = 0
    else:
        a = float(var_a.get())
        f = float(var_f.get())
    
    return a, f, shape


def print_entries():

    num, samp_freq = get_dig_entries(var_num,
                                     var_samp_freq)
    a, f, shape = get_wav_entries(var_a, var_f, var_shape)
    print(num, samp_freq)
    print(a, f, shape)

    return


def create_control(container, label, char_width=20):

    lbl = tk.Label(container, text=label)
    lbl.pack()

    frame = tk.Frame(container, bg='blue', bd=2)
    frame.pack()

    var_ent = tk.StringVar()
    ent = tk.Entry(frame, textvariable=var_ent,
                   justify=tk.CENTER, width=char_width)
    ent.pack(fill=tk.X)

    return var_ent


def get_control_string(var_ent):

    control_string = var_ent.get()

    return control_string


def create_indicator(container, label_1,
                     label_2='', char_width=20):

    lbl_1 = tk.Label(container, text=label_1)
    lbl_1.pack()

    frame = tk.Frame(container, bg='blue', bd=2)
    frame.pack()

    lbl_2 = tk.Label(frame, text=label_2, width=char_width)
    lbl_2.pack(fill=tk.X)

    return lbl_2



if __name__ == '__main__':
    
    root = create_window(title='Waveform Simulator')
    control_box, right_frame = create_frames(root)
    var_num,var_samp_freq = digitizing_control(control_box)
    var_a, var_f, var_shape = waveform_control(control_box)
    btn = action_button(control_box,label='Submit',
                        action=print_entries)
    root.mainloop()
